#!/bin/sh

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# JaDOrT: JASMINe Deployment Orchestration Tool
# Copyright (C) 2008 Bull S.A.S.
# Copyright (C) 2008 France Telecom R&D
# Contact: jasmine@ow2.org
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
# USA
#
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# $Id: start.sh 2919 2008-12-18 13:45:45Z alitokmen $
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

servers=
while [ "$#" -gt 0 ]
do
	servers="$servers $1"
	shift
done

if [ "" = "$servers" ]
then
	echo "Enter JOnAS server numbers, separated by a space"
	read servers
fi

rm -Rf jadort-samples-launcher
mkdir jadort-samples-launcher
pushd jadort-samples-launcher

tar xvzf ../jonas-osgi-*-bin.tar.gz
mv jonas-osgi-*/ root/
export JONAS_ROOT=$PWD/root
dos2unix $JONAS_ROOT/conf/*.*

for jonas in $servers
do
	mkdir $jonas
	export JONAS_BASE=$PWD/$jonas
	cp -r $JONAS_ROOT/conf $JONAS_BASE/conf
#	cp -r $JONAS_ROOT/deploy $JONAS_BASE/deploy
	pushd $JONAS_BASE/conf
	sed s/@targetPortStart@/$jonas/ ../../../jonas_config_delta.diff | patch
	popd
	$JONAS_ROOT/bin/jonas start -n jonas$jonas -Ddomain.name=jonas
done

popd
